﻿////////////////////////////////////////////////////////
//
//  AVEN in AsLite GROUP
//
////////////////////////////////////////////////////////
package cn.com.aven
{	/**
     * Guider 
     * @by aven 2009.6.20
     * @www.aven.com.cn
     * @version 1.1
     */
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.filters.BlurFilter;
    import flash.filters.DropShadowFilter;
    import flash.filters.GlowFilter;
    import flash.utils.Dictionary;
    import flash.utils.getTimer;
    
    public class Guider extends EventDispatcher
    {
    	private static var _GuideAll : Dictionary = new Dictionary();//save all guider target
    	private static var _RunGuide : Boolean;//whether having use guider now
    	private static var _Sprite : Sprite = new Sprite();//guider use enterfarme event object
        public var target : Object;//guider object
        public var duration : uint;//guider all time
        public var running : Boolean;//target whether running
        public var pauseBool : Boolean;//target whether pause
        public var completeBool : Boolean;//target whether complete
        private var _currentTime : uint;//guider had use time
        private var _startTime : uint;//guider start time value
        private var _historyTime : uint = 0;//guider history time value
        private var _tween : Array;//use tween change value (array)
        private var _blur : Object;//use blur change value
     	private var _glow : Object;//use glow change value
     	private var _shadow : Object;//use shadow change value
     	private var _resize : Object;//use resize change value
     	private var _guide : Array;//use guide line change value(array)
     	private var _curve : Array;//use customeEasing change value(array)
        private var _usingFunction : Function = defaultFunction;//use easing function
     	
     	/**
     	 *  current guider and return guider object
     	 */
        public static function to($target:DisplayObject,$vars:Object,$duration:uint = 1000):Guider
         {
              return new Guider($target,$vars,$duration);
         }
        
        /**
     	 *  construct methods
     	 */
        public function Guider($target:DisplayObject,$vars:Object,$duration:uint = 1000)
        {
            if(!$target && (!$vars.tween || !$vars.blur || !$vars.glow || !$vars.guide || !$vars.shadow || !$vars.resize)) return;
            
            target = $target;
            
            if(_GuideAll[$target] || _GuideAll[$target] != undefined) delete _GuideAll[$target];
            
            if($vars.tween) initVars($vars.tween);
            if($vars.blur) _blur = otherVars($vars.blur);
            if($vars.glow) _glow = otherVars($vars.glow);
            if($vars.shadow) _shadow = otherVars($vars.shadow);
            if($vars.resize) _resize = otherVars($vars.resize);
            
            if($vars.guide) _guide = $vars.guide;
            if($vars.cus) _curve = $vars.cus;
            
            if($vars.ease != null && $vars.ease is Function) _usingFunction = $vars.ease;
            
            if(!isNaN($duration) && $duration > 0) duration = $duration;
            
            if(!_RunGuide)
            {
            	_RunGuide = true;
            	_Sprite.addEventListener(Event.ENTER_FRAME,onEnterFrameEvent)
            }
            
            _startTime = getTimer();
            running = true;
            _GuideAll[$target] = this;
        }
        
         /**
     	 *  initVars set tween value,if use tween
     	 */
        private function initVars($vars : Object):void
        {
			_tween = [];
        	for (var p : String in $vars)
        	{
        		_tween.push({name : p ,startValue : target[p],endValue : $vars[p]});
        	} 
        }
        
         /**
     	 *  otherVars set blur,glow,shadow,resize value ,if use blur,glow,shadow,resize
     	 */
        private function otherVars($vars : Object) : Object
        {
        	var obj : Object = {};
        	for (var p : String in $vars)
        	{
        		obj[p] = $vars[p];
        	}
        	return obj;
        }
        
        /**
        * onEnterFrameEvent let all target to change value
        */
        private static function onEnterFrameEvent($e : Event,$t : uint = 0,$q :Object = null,$c : int = 0):void
        {
//			$t = getTimer();
			for ($q in _GuideAll) 
			{
				if (_GuideAll[$q] != undefined && _GuideAll[$q] != null)
				{
					if(_GuideAll[$q].running)
					{
						_GuideAll[$q].enterChangeEvent();
					}
					$c++;
					
				}
			}
			if($c == 0)
			{
				_Sprite.removeEventListener(Event.ENTER_FRAME,onEnterFrameEvent);
				_RunGuide = false;
			}
        }
        
        /**
        * enterChangeEvent guider set target value
        */
        public function enterChangeEvent():void
        {
        	_currentTime = getTimer() - _startTime + _historyTime;
            if (_currentTime >= duration)
            {
            	onEndGuide();
            }
            else
            {
				_curve ? onGuideBestUpdate(_usingFunction(_currentTime,0,1,duration,_curve)) : onGuideBestUpdate(_usingFunction(_currentTime,0,1,duration));
            }
        }
        
        /**
        * onEndGuide target end guider
        */
        private function onEndGuide():void
        {
//        	trace(_currentTime + " --- " + this._startTime + this.running);
        	_currentTime = duration;
        	running = false;
        	completeBool = true;
        	onGuideBestUpdate();
        }
        
        /**
        * onGuideBestUpdate update target value
        */
        private function onGuideBestUpdate($value : Number = 1):void
        {
        	for each(var p : Object in _tween)
        	{
        		target[p.name] = (p.endValue - p.startValue)*$value + p.startValue;
        	}
        	if(_resize)
        	{
        		 (_resize.heightTo && _resize.heightFrom) ? target.height = (_resize.heightTo - _resize.heightFrom)*$value + _resize.heightFrom : 0;
        		 (_resize.widthTo && _resize.widthFrom) ?  target.width = (_resize.widthTo - _resize.widthFrom)*$value + _resize.widthFrom : 0;
        	}
            if(_blur || _glow || _shadow)
            {
            	target.filters = null;
	            var arr : Array = [];
	            if(_blur)
	            {
            		_blur.blurX = (_blur.blurXTo || _blur.blurXFrom) ? ((_blur.blurXTo || 0) - (_blur.blurXFrom || 0))*$value + (_blur.blurXFrom || 0) : 0;
            		_blur.blurY = (_blur.blurYTo || _blur.blurYFrom) ? ((_blur.blurYTo || 0) - (_blur.blurYFrom || 0))*$value + (_blur.blurYFrom || 0) : 0;
            		_blur.quality = _blur.quality || 1 ;
            		arr.push(new BlurFilter(_blur.blurX,_blur.blurY,_blur.quality));
	            }
	            if(_glow)
	            {
	            	_glow.blurX = (_glow.blurXTo || _glow.blurXFrom) ? ((_glow.blurXTo || 0) - (_glow.blurXFrom || 0))*$value + (_glow.blurXFrom || 0) : 0;
            		_glow.blurY = (_glow.blurYTo || _glow.blurYFrom) ? ((_glow.blurYTo || 0) - (_glow.blurYFrom || 0))*$value + (_glow.blurYFrom || 0) : 0;
            		_glow.alpha = (_glow.alphaTo || _glow.alphaFrom) ? ((_glow.alphaTo || 0) - (_glow.alphaFrom || 0))*$value + (_glow.alphaFrom || 0) : 0;
            		_glow.color = _glow.color;
	            	_glow.strength = _glow.strength || 2;
	            	_glow.quality = _glow.quality || 1;
	            	_glow.inner = _glow.inner || false;
	            	_glow.knockout = _glow.knockout || false;
	            	arr.push(new GlowFilter(_glow.color,_glow.alpha,_glow.blurX,_glow.blurY,_glow.strength,_glow.quality,_glow.inner,_glow.knockout));
	            }
	             if(_shadow)
	            {
	            	_shadow.blurX = _shadow.blurX || 0;
            		_shadow.blurY = _shadow.blurY || 0;
            		_shadow.alpha = (_shadow.alphaTo || _shadow.alphaFrom) ? ((_shadow.alphaTo || 0) - (_shadow.alphaFrom || 0))*$value + (_shadow.alphaFrom || 0) : 0;
            		_shadow.color = _shadow.color;
	            	_shadow.strength = _shadow.strength || 2;
	            	_shadow.inner = _shadow.inner || false;
	            	_shadow.knockout = _shadow.knockout || false;
	            	_shadow.angle = _shadow.angle || 0;
	            	_shadow.distance = _shadow.distance || 0;
	            	_shadow.quality = _shadow.quality || 1;
	            	_shadow.hideObject = _shadow.hideObject || false;
	            	arr.push(new DropShadowFilter(_shadow.distance,_shadow.angle,
	            		_shadow.color,_shadow.alpha,_shadow.blurX,_shadow.blurY,_shadow.strength,_shadow.quality,_shadow.inner,_shadow.knockout,_shadow.hideObject));
	            }
	            target.filters = arr;
	        }
	        if(_guide) guideLine($value * duration);
        	if(_currentTime == duration)
        	{
				removeGuide(this);
        		dispatchEvent(new GuiderEvent(GuiderEvent.GuiderEvent_PROGRESS,duration,duration));
        		dispatchEvent(new GuiderEvent(GuiderEvent.GuiderEvent_COMPLETE));
        	}
        	else
        	{
        		dispatchEvent(new GuiderEvent(GuiderEvent.GuiderEvent_PROGRESS,_currentTime,duration));
        	}
        }
        
        /**
        * removeGuide remove target 
        */
        public static function removeGuide($guide : Guider = null):void 
        {
			if ($guide != null && $guide.target != null) {
				delete _GuideAll[$guide.target];
			}
		}
  		
  		/**
        * guideLine update target x,y ,if use guide line
        */
        private function guideLine(t : Number,obj : Object = null,
        							a:int = 0,p:Number = 0,
        							w:Number = 0,le : int = 0):void
		{
			le = _guide.length - 1;
			if(t > 0 && t < duration)
			{
				 for(;a < le ;a++)
	            {
	            	if(t < ((p + _guide[a].Ti)/_guide[le].Ti)*duration)
	            	{
	            		break;
	            	}
	            	p = p + _guide[a].Ti;
	            }
	            obj = _guide[a];
            	w = ((t/duration)*_guide[le].Ti - p)/(obj.Ti);
			}
			else
			{
				if(t >= duration) a = le-1;
				w = t/duration;
				obj = _guide[a];
			}
	        target.x = (Math.pow((1-w),2)*obj.Gx + 2*w*(1-w)*obj.Nx + Math.pow(w,2)*_guide[a+1].Gx);
			target.y = (Math.pow((1-w),2)*obj.Gy + 2*w*(1-w)*obj.Ny + Math.pow(w,2)*_guide[a+1].Gy);
		}
        
        /**
        * end end target guider
        */
        public function end():void
        {
        	if(!completeBool) onEndGuide();
        }
        
        /**
        * pause pause target guider
        */
        public function pause():void
        {
        	if(!completeBool && !pauseBool)
        	{
        		_historyTime = getTimer() - _startTime + _historyTime;
	        	pauseBool = !pauseBool;
	        	running = false;
        	}
        }
        
        /**
        * resume resume target guider
        */
        public function resume():void
        {
        	if(!completeBool && pauseBool)
			{
				pauseBool = !pauseBool;
	        	_startTime = getTimer();
	        	running = true;
			}
        }
        
        /**
        * defaultFunction target use easing function
        */
        private static function defaultFunction(t:Number, b:Number,
                                               c:Number, d:Number,
                                               ca : Array = null):Number
        {
            return c / 2 * (Math.sin(Math.PI * (t / d - 0.5)) + 1) + b;
        }
    }
}

