﻿////////////////////////////////////////////////////////
//
//  AVEN in AsLite GROUP
//
////////////////////////////////////////////////////////
package cn.com.aven
{
     /**
     * GuiderEase 
     * @by aven 2009.6.20
     * @www.aven.com.cn
     * @version 1.1
     */
    public class GuiderEase
    {
        /**
         *  CustomEase target对象Guider自定义缓和函数
         */
        public static var CustomEase : Function = easeCustom;
        
        /**
         *  BackEaseIn 方法开始时朝后运动，然后反向朝目标移动
         */
        public static var BackEaseIn : Function = Back_easeIn;
        
        /**
         *  BackEaseOut 方法开始运动时是朝目标移动，稍微过冲，再倒转方向回来朝着目标
         */
        public static var BackEaseOut : Function = Back_easeOut;
        
        /**
         *  BackEaseInOut 方法结合了 easeIn() 和 easeOut() 方法的运动，
         * 开始运动时是朝后跟踪，再倒转方向并朝目标移动，稍微过冲目标，
         * 然后再次倒转方向，回来朝目标移动
         */
        public static var BackEaseInOut : Function = Back_easeInOut;
        
        /**
         *  BounceEaseIn 方法以较慢速度开始回弹运动，然后在执行时加快运动速度
         */
        public static var BounceEaseIn : Function = Bounce_easeIn;
        
        /**
         *  BounceEaseOut 方法以较快速度开始回弹运动，然后在执行时减慢运动速度
         */
        public static var BounceEaseOut : Function = Bounce_easeOut;
        
        /**
         *  BounceEaseInOut 方法结合了 easeIn() 和 easeOut() 方法的运动，
         * 缓慢地开始跳动，进行加速运动，再进行减速。
         */
        public static var BounceEaseInOut : Function = Bounce_easeInOut;
        
        /**
         *  CircularEaseIn 方法以较慢速度开始运动，然后在执行时加快运动速度
         */
        public static var CircularEaseIn : Function = Circular_easeIn;
        
        /**
         *  CircularEaseOut 方法以较快速度开始运动，然后在执行时减慢运动速度
         */
        public static var CircularEaseOut : Function = Circular_easeOut;
        
        /**
         *  CircularEaseInOut 方法结合了 easeIn() 和 easeOut() 方法的运动，
         * 缓慢地开始跳动，进行加速运动，再进行减速。
         */
        public static var CircularEaseInOut : Function = Circular_easeInOut;
        
        /**
         *  CubicEaseIn 方法以零速率开始运动，然后在执行时加快运动速度
         */
        public static var CubicEaseIn : Function = Cubic_easeIn;
        
        /**
         *  CubicEaseOut 方法以较快速度开始运动，然后在执行时减慢运动速度，直至速率为零
         */
        public static var CubicEaseOut : Function = Cubic_easeOut;
        
        /**
         *  CubicEaseInOut 方法兼有 easeIn() 方法和 easeOut() 方法的运动，
         * 开始运动时速率为零，先对运动进行加速，再减速直到速率为零
         */
        public static var CubicEaseInOut : Function = Cubic_easeInOut;
        
        /**
         *  ElasticEaseIn 方法以较慢速度开始运动，然后在执行时加快运动速度
         */
        public static var ElasticEaseIn : Function = Elastic_easeIn;
        
        /**
         *  ElasticEaseOut 方法以较快速度开始运动，然后在执行时减慢运动速度
         */
        public static var ElasticEaseOut : Function = Elastic_easeOut;
        
        /**
         *  ElasticEaseInOut 方法结合了 easeIn() 和 easeOut() 方法的运动，
         * 缓慢地开始运动，进行加速运动，再进行减速
         */
        public static var ElasticEaseInOut : Function = Elastic_easeInOut;
        
        /** Exponential 类可以定义三个缓动函数 
         *              运动由按指数方式衰减的正弦波来定义
         *  ExponentialEaseIn 方法以较慢速度开始运动，然后在执行时加快运动速度
         */
        public static var ExponentialEaseIn : Function = Exponential_easeIn;
        
        /**
         *  ExponentialEaseOut 方法以较快速度开始运动，然后在执行时减慢运动速度
         */
        public static var ExponentialEaseOut : Function = Exponential_easeOut;
        
        /**
         *  ExponentialEaseInOut 方法结合了 easeIn() 和 easeOut() 方法的运动，
         * 缓慢地开始运动，进行加速运动，再进行减速
         */
        public static var ExponentialEaseInOut : Function = Exponential_easeInOut;
        
        /** Linear 类可以定义缓动函数，以便使用 Flex 效果类实现线性运动
         *  LinearEaseIn 方法以零速率开始运动，然后在执行时加快运动速度
         */
        public static var LinearEaseIn : Function = Linear_easeIn;
        
        /**
         *  LinearEaseOut 方法以较快速度开始运动，然后在执行时减慢运动速度，直至速率为零
         */
        public static var LinearEaseOut : Function = Linear_easeOut;
        
        /**
         *  LinearEaseInOut 方法兼有 easeIn() 方法和 easeOut() 方法的运动，
         * 开始运动时速率为零，先对运动进行加速，再减速直到速率为零
         */
        public static var LinearEaseInOut : Function = Linear_easeInOut;
        
        /**
         *  LinearEaseNone 方法定义一种没有加速的持续运动
         */
        public static var LinearEaseNone : Function = Linear_easeNone;
        
        
        /** Quadratic Quadratic 缓动方程的运动加速小于 Cubic 或 Quartic 缓动方程
         *  QuadraticEaseIn 方法以零速率开始运动，然后在执行时加快运动速度
         */
        public static var QuadraticEaseIn : Function = Quadratic_easeIn;
        
        /**
         *  QuadraticEaseOut 方法以较快速度开始运动，然后在执行时减慢运动速度，直至速率为零
         */
        public static var QuadraticEaseOut : Function = Quadratic_easeOut;
        
        /**
         *  QuadraticEaseInOut 方法兼有 easeIn() 方法和 easeOut() 方法的运动，
         * 开始运动时速率为零，先对运动进行加速，再减速直到速率为零
         */
        public static var QuadraticEaseInOut : Function = Quadratic_easeInOut;
        
        /** Quintic Quintic Quintic 缓动方程的运动加速大于 Quadratic、Cubic
         *  或 Quartic 缓动方程
         *  QuinticEaseIn  方法以零速率开始运动，然后在执行时加快运动速度
         */
        public static var QuinticEaseIn : Function = Quintic_easeIn;
        
        /**
         *  QuinticEaseOut 方法以较快速度开始运动，然后在执行时减慢运动速度，直至速率为零
         */
        public static var QuinticEaseOut : Function = Quintic_easeOut;
        
        /**
         *  QuinticEaseInOut 方法兼有 easeIn() 方法和 easeOut() 方法的运动，
         * 开始运动时速率为零，先对运动进行加速，再减速直到速率为零
         */
        public static var QuinticEaseInOut : Function = Quintic_easeInOut;
        
        /** Sine 类可以定义三个缓动函数，以便使用 Flex 效果类实现运动，
         * 其中的运动由正弦波定义
         *  SineEaseIn  方法以零速率开始运动，然后在执行时加快运动速度
         */
        public static var SineEaseIn : Function = Sine_easeIn;
        
        /**
         *  SineEaseOut 方法以较快速度开始运动，然后在执行时减慢运动速度，直至速率为零
         */
        public static var SineEaseOut : Function = Sine_easeOut;
        
        /**
         *  SineEaseInOut 方法兼有 easeIn() 方法和 easeOut() 方法的运动，
         * 开始运动时速率为零，先对运动进行加速，再减速直到速率为零
         */
        public static var SineEaseInOut : Function = Sine_easeInOut;


        /**
         *  easeCustom listener对象TweenLi自定义缓和函数
         *  t 已经使用的时间
         *  b 对象的属性开始值
         *  c 结束值于开始值的差
         *  d 对象缓和持续的时间
         *  ca 自定义缓和的数组
         *  a 数组当前的位置
         */
        private static function easeCustom(t:Number, b:Number,
                                      c:Number, d:Number,ca : Array):Number
        {
        	 var a:Number = 0, p:Number = ca.length -1;
             var obj : Object;
             
             while(t >= (ca[a].Mx/ca[p].Mx)*d && a < p) obj = ca[a++];
             var w:Number = ((t/d)*ca[p].Mx-obj.Mx)/(ca[a].Mx-obj.Mx);
             return (Math.pow((1-w),2)*obj.My + 2*w*(1-w)*obj.Ny + Math.pow(w,2)*ca[a].My)/(ca[p].My)*c + b;
        }
        
        /**
         *  The <code>easeIn()</code> method starts motion slowly, 
         *  and then accelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @param a Specifies the amplitude of the sine wave.
         *
         *  @param p Specifies the period of the sine wave.
         *
         *  @return Number corresponding to the position of the component.
         */  
        private static function Elastic_easeIn(t:Number, b:Number,
                                      c:Number, d:Number, a:Number = 0, p:Number = 0):Number
        {
            if (t == 0)
                return b;
            
            if ((t /= d) == 1)
                return b + c;
            
            if (!p)
                p = d * 0.3;
            
            var s:Number;
            if (!a || a < Math.abs(c))
            {
                a = c;
                s = p / 4;
            }
            else
            {
                s = p / (2 * Math.PI) * Math.asin(c / a);
            }
    
            return -(a * Math.pow(2, 10 * (t -= 1)) *
                     Math.sin((t * d - s) * (2 * Math.PI) / p)) + b;
        }
    
        /**
         *  The <code>easeOut()</code> method starts motion fast, 
         *  and then decelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @param a Specifies the amplitude of the sine wave.
         *
         *  @param p Specifies the period of the sine wave.
         *
         *  @return Number corresponding to the position of the component.
         */  
        private static function Elastic_easeOut(t:Number, b:Number,
                                       c:Number, d:Number,
                                      a:Number = 0, p:Number = 0):Number
        {
            if (t == 0)
                return b;
                
            if ((t /= d) == 1)
                return b + c;
            
            if (!p)
                p = d * 0.3;
    
            var s:Number;
            if (!a || a < Math.abs(c))
            {
                a = c;
                s = p / 4;
            }
            else
            {
                s = p / (2 * Math.PI) * Math.asin(c / a);
            }
    
            return a * Math.pow(2, -10 * t) *
                   Math.sin((t * d - s) * (2 * Math.PI) / p) + c + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the motion slowly, accelerate motion, then decelerate. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @param a Specifies the amplitude of the sine wave.
         *
         *  @param p Specifies the period of the sine wave.
         *
         *  @return Number corresponding to the position of the component.
         */  
        private static function Elastic_easeInOut(t:Number, b:Number,
                                        c:Number, d:Number,
                                          a:Number = 0, p:Number = 0):Number
        {
            if (t == 0)
                return b;
                
            if ((t /= d / 2) == 2)
                return b + c;
                
            if (!p)
                p = d * (0.3 * 1.5);
    
            var s:Number;
            if (!a || a < Math.abs(c))
            {
                a = c;
                s = p / 4;
            }
            else
            {
                s = p / (2 * Math.PI) * Math.asin(c / a);
            }
    
            if (t < 1)
            {
                return -0.5 * (a * Math.pow(2, 10 * (t -= 1)) *
                       Math.sin((t * d - s) * (2 * Math.PI) /p)) + b;
            }
            
            return a * Math.pow(2, -10 * (t -= 1)) *
                   Math.sin((t * d - s) * (2 * Math.PI) / p ) * 0.5 + c + b;
                   new Back
        }
        
        /**
         *  The <code>easeIn()</code> method starts 
         *  the motion by backtracking, 
         *  then reversing direction and moving toward the target.
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @param s Specifies the amount of overshoot, where the higher the value, 
         *  the greater the overshoot.
         *
         *  @return Number corresponding to the position of the component.
         */  
        private static function Back_easeIn(t:Number, b:Number,
                                        c:Number, d:Number,
                                          s:Number = 0):Number
        {
            if (!s)
                s = 1.70158;
            
            return c * (t /= d) * t * ((s + 1) * t - s) + b;
        }
    
        /**
         *  The <code>easeOut()</code> method starts the motion by
         *  moving towards the target, overshooting it slightly, 
         *  and then reversing direction back toward the target.
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @param s Specifies the amount of overshoot, where the higher the value, 
         *  the greater the overshoot.
         *
         *  @return Number corresponding to the position of the component.
         */  
        private static function Back_easeOut(t:Number, b:Number,
                                       c:Number, d:Number,
                                       s:Number = 0):Number
        {
            if (!s)
                s = 1.70158;
            
            return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the motion by backtracking, then reversing direction and 
         *  moving toward target, overshooting target slightly, reversing direction again, and 
         *  then moving back toward the target.
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @param s Specifies the amount of overshoot, where the higher the value, 
         *  the greater the overshoot.
         *
         *  @return Number corresponding to the position of the component.
         */  
        private static function Back_easeInOut(t:Number, b:Number,
                                         c:Number, d:Number,
                                           s:Number = 0):Number
        {
            if (!s)
                s = 1.70158; 
            
            if ((t /= d / 2) < 1)
                return c / 2 * (t * t * (((s *= (1.525)) + 1) * t - s)) + b;
            
            return c / 2 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2) + b;
        }
        
        /**
         *  The <code>easeOut()</code> method starts the bounce motion fast, 
         *  and then decelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Bounce_easeOut(t:Number, b:Number,
                                       c:Number, d:Number):Number
        {
            if ((t /= d) < (1 / 2.75))
                return c * (7.5625 * t * t) + b;
            
            else if (t < (2 / 2.75))
                return c * (7.5625 * (t -= (1.5 / 2.75)) * t + 0.75) + b;
            
            else if (t < (2.5 / 2.75))
                return c * (7.5625 * (t -= (2.25 / 2.75)) * t + 0.9375) + b;
            
            else
                return c * (7.5625 * (t -= (2.625 / 2.75)) * t + 0.984375) + b;
        }
    
        /**
         *  The <code>easeIn()</code> method starts the bounce motion slowly, 
         *  and then accelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Bounce_easeIn(t:Number, b:Number,
                                      c:Number, d:Number):Number
        {
            return c - Bounce_easeOut(d - t, 0, c, d) + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the bounce motion slowly, accelerate motion, then decelerate. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Bounce_easeInOut(t:Number, b:Number,
                                         c:Number, d:Number):Number
        {
            if (t < d/2)
                return Bounce_easeIn(t * 2, 0, c, d) * 0.5 + b;
            else
                return Bounce_easeOut(t * 2 - d, 0, c, d) * 0.5 + c * 0.5 + b;
        }
    
        /**
         *  The <code>easeIn()</code> method starts motion slowly, 
         *  and then accelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Circular_easeIn(t:Number, b:Number,
                                      c:Number, d:Number):Number
        {
            return -c * (Math.sqrt(1 - (t /= d) * t) - 1) + b;
        }
    
        /**
         *  The <code>easeOut()</code> method starts motion fast, 
         *  and then decelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Circular_easeOut(t:Number, b:Number,
                                       c:Number, d:Number):Number
        {
            return c * Math.sqrt(1 - (t = t/d - 1) * t) + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the motion slowly, accelerate motion, then decelerate. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Circular_easeInOut(t:Number, b:Number,
                                         c:Number, d:Number):Number
        {
            if ((t /= d / 2) < 1)
                return -c / 2 * (Math.sqrt(1 - t * t) - 1) + b;
    
            return c / 2 * (Math.sqrt(1 - (t -= 2) * t) + 1) + b;
        }
        
         /**
         *  The <code>easeIn()</code> method starts motion from zero velocity, 
         *  and then accelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Cubic_easeIn(t:Number, b:Number,
                                      c:Number, d:Number):Number
        {
            return c * (t /= d) * t * t + b;
        }
    
        /**
         *  The <code>easeOut()</code> method starts motion fast, 
         *  and then decelerates motion to a zero velocity as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Cubic_easeOut(t:Number, b:Number,
                                       c:Number, d:Number):Number
        {
            return c * ((t = t / d - 1) * t * t + 1) + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the motion from zero velocity, accelerates motion, then decelerates
         *  back to a zero velocity. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Cubic_easeInOut(t:Number, b:Number,
                                         c:Number, d:Number):Number
        {
            if ((t /= d / 2) < 1)
                return c / 2 * t * t * t + b;
    
            return c / 2 * ((t -= 2) * t * t + 2) + b;
        }
        
        /**
         *  The <code>easeIn()</code> method starts motion slowly, 
         *  and then accelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Exponential_easeIn(t:Number, b:Number,
                                      c:Number, d:Number):Number
        {
            return t == 0 ? b : c * Math.pow(2, 10 * (t / d - 1)) + b;
        }
    
        /**
         *  The <code>easeOut()</code> method starts motion fast, 
         *  and then decelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Exponential_easeOut(t:Number, b:Number,
                                       c:Number, d:Number):Number
        {
            return t == d ? b + c : c * (-Math.pow(2, -10 * t / d) + 1) + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion 
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the motion slowly, accelerate motion, then decelerate. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Exponential_easeInOut(t:Number, b:Number,
                                         c:Number, d:Number):Number
        {
            if (t == 0)
                return b;
    
            if (t == d)
                return b + c;
    
            if ((t /= d / 2) < 1)
                return c / 2 * Math.pow(2, 10 * (t - 1)) + b;
    
            return c / 2 * (-Math.pow(2, -10 * --t) + 2) + b;
        }
        
        /**
         *  The <code>easeNone()</code> method defines a constant motion, 
         *  with no acceleration. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Linear_easeNone(t:Number, b:Number,
                                        c:Number, d:Number):Number
        {
            return c * t / d + b;
        }
    
        /**
         *  The <code>easeIn()</code> method starts motion from zero velocity, 
         *  and then accelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Linear_easeIn(t:Number, b:Number,
                                      c:Number, d:Number):Number
        {
            return c * t / d + b;
        }
    
        /**
         *  The <code>easeOut()</code> method starts motion fast, 
         *  and then decelerates motion to a zero velocity as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Linear_easeOut(t:Number, b:Number,
                                       c:Number, d:Number):Number
        {
            return c * t / d + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion 
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the motion from zero velocity, accelerate motion, 
         *  then decelerate back to zero velocity. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Linear_easeInOut(t:Number, b:Number,
                                         c:Number, d:Number):Number
        {
            return c * t / d + b;
        }
        
        /**
         *  The <code>easeIn()</code> method starts motion from a zero velocity, 
         *  and then accelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Quadratic_easeIn(t:Number, b:Number,
                                      c:Number, d:Number):Number
        {
            return c * (t /= d) * t + b;
        }
    
        /**
         *  The <code>easeOut()</code> method starts motion fast, 
         *  and then decelerates motion to a zero velocity as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Quadratic_easeOut(t:Number, b:Number,
                                       c:Number, d:Number):Number
        {
            return -c * (t /= d) * (t - 2) + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the motion from a zero velocity, 
         *  accelerate motion, then decelerate to a zero velocity. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Quadratic_easeInOut(t:Number, b:Number,
                                         c:Number, d:Number):Number
        {
            if ((t /= d / 2) < 1)
                return c / 2 * t * t + b;
    
            return -c / 2 * ((--t) * (t - 2) - 1) + b;
        }
        
         /**
         *  The <code>easeIn()</code> method starts motion from zero velocity, 
         *  and then accelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Quintic_easeIn(t:Number, b:Number,
                                      c:Number, d:Number):Number
        {
            return c * (t /= d) * t * t * t * t + b;
        }
    
        /**
         *  The <code>easeOut()</code> method starts motion fast, 
         *  and then decelerates motion to a zero velocity as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Quintic_easeOut(t:Number, b:Number,
                                       c:Number, d:Number):Number 
        {
            return c * ((t = t / d - 1) * t * t * t * t + 1) + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the motion from a zero velocity, accelerate motion, 
         *  then decelerate to a zero velocity. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Quintic_easeInOut(t:Number, b:Number,
                                         c:Number, d:Number):Number
        {
            if ((t /= d / 2) < 1)
                return c / 2 * t * t * t * t * t + b;
    
            return c / 2 * ((t -= 2) * t * t * t * t + 2) + b;
        }
        
        /**
         *  The <code>easeIn()</code> method starts motion from zero velocity, 
         *  and then accelerates motion as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Sine_easeIn(t:Number, b:Number,
                                      c:Number, d:Number):Number
        {
            return -c * Math.cos(t / d * (Math.PI / 2)) + c + b;
        }
    
        /**
         *  The <code>easeOut()</code> method starts motion fast, 
         *  and then decelerates motion to a zero velocity as it executes. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Sine_easeOut(t:Number, b:Number,
                                       c:Number, d:Number):Number
        {
            return c * Math.sin(t / d * (Math.PI / 2)) + b;
        }
    
        /**
         *  The <code>easeInOut()</code> method combines the motion
         *  of the <code>easeIn()</code> and <code>easeOut()</code> methods
         *  to start the motion from a zero velocity, accelerate motion, 
         *  then decelerate to a zero velocity. 
         *
         *  @param t Specifies time.
         *
         *  @param b Specifies the initial position of a component.
         *
         *  @param c Specifies the total change in position of the component.
         *
         *  @param d Specifies the duration of the effect, in milliseconds.
         *
         *  @return Number corresponding to the position of the component.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 9
         *  @playerversion AIR 1.1
         *  @productversion Flex 3
         */  
        private static function Sine_easeInOut(t:Number, b:Number,
                                         c:Number, d:Number):Number
        {
            return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
        }
    }
}
