﻿package com.activetofocus.photoviewer
{
	import com.activetofocus.utils.Resizer;
	import com.activetofocus.utils.LoadXmlData;
	import com.activetofocus.utils.TipTool;
	import com.activetofocus.events.LoadDataEvent;
	import com.activetofocus.events.TipToolEvent;
	import com.activetofocus.photoviewer.model.GalleryVO;
	import com.activetofocus.photoviewer.view.CategoryView;
	import com.activetofocus.photoviewer.view.ImageView;
	import com.activetofocus.photoviewer.events.ScrollImageEvent;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.net.navigateToURL;
	import flash.display.StageDisplayState;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	
	/**
	 * PhotoViewer
	 *
	 * @author activetofocus team
	 * @since  2010-05-22
	 */
	public class PhotoViewer extends MovieClip
	{
		//--------------------------------------
		//  Variables
		//--------------------------------------
		
		/**
		 *  xml file
		 */
		private var _xml:XML;
		
		/**
		 *  style
		 */
		private var _categoryStyle:Object;
		private var _photoStyle:Object;
		 
		/**
		 *  item data
		 */
		private var _itemArray:Array;//item array
		private var _itemLength:int;//item length	
		
		/**
		 *  all panel
		 */
		private var _categoryView:CategoryView;// photo gallery category menu
		private var _imageView:ImageView; // photo show panel
		
		/**
    	 *  constructor
     	 */
		public function PhotoViewer()
		{
			
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		
		/**
		 *  start loader xml file
		 */
		public function init():void
		{
			this.stage.showDefaultContextMenu = false;
			this.stage.align = StageAlign.TOP_LEFT;
	    	this.stage.scaleMode = StageScaleMode.NO_SCALE;

			var loadXmlData:LoadXmlData = new LoadXmlData();
			loadXmlData.addEventListener(LoadDataEvent.LOAD_COMPLETE,onLoadXmlComplete);
			loadXmlData.load("photoviewerXML.xml");
		}
		
		/**
		 *  analyze xml files
		 */
		private function analyzeXml():void
		{
			//trace(_xml);
			// style
			_categoryStyle = {};
			
			_categoryStyle.categorymenuspacing  = Number(_xml.style.categorymenu.categorymenuspacing) || 50;
			_categoryStyle.categoryimageheigh   = Number(_xml.style.categorymenu.categoryimageheigh) || 120;
			_categoryStyle.categoryeffectdelay  = Number(_xml.style.categorymenu.categoryeffectdelay) || 0.5;
			
			_categoryStyle.titleseletecolor     = uint(_xml.style.categorymenu.titleseletecolor);
			_categoryStyle.titledefaultcolor    = uint(_xml.style.categorymenu.titledefaultcolor);
			_categoryStyle.titleglow            = Number(_xml.style.categorymenu.titleglow) || 8;
			_categoryStyle.titledelaytime       = Number(_xml.style.categorymenu.titledelaytime) || 0.5;
			
			_categoryStyle.imagescrollspacing   = Number(_xml.style.categorymenu.imagescrollspacing) || 70;
			_categoryStyle.imagescrolldelaytime = Number(_xml.style.categorymenu.imagescrolldelaytime) || 0.3;
			
			_photoStyle = {};
			_photoStyle.bgcolor                 = uint(_xml.style.photostyle.bgcolor);
			
			_photoStyle.bgalpha                 = Number(_xml.style.photostyle.bgalpha) || 0.5;
			_photoStyle.delaytime               = Number(_xml.style.photostyle.delaytime) || 0.5;
			
			_photoStyle.imagebgcolor            = uint(_xml.style.photostyle.imagebgcolor);
			_photoStyle.imagebgalpha            = Number(_xml.style.photostyle.imagebgalpha) || 1;
			_photoStyle.imagebgborderthickness  = Number(_xml.style.photostyle.imagebgborderthickness) || 8;
			_photoStyle.imagedelaytime          = Number(_xml.style.photostyle.imagedelaytime) || 0.3 ;
			
			// item data
			_itemLength = int(_xml.items.item.length());
			_itemArray  = [];
			for(var i :int=0; i < _itemLength; i++)
			{
				var obj:Object = {};
				var gLength:int = int(_xml.items.item[i].img.length());
				
				obj.title = _xml.items.item[i].@title;
				obj.galleryArr = [];
				
				for(var j:int = 0; j < gLength; j++)
				{
					obj.galleryArr.push(new GalleryVO(_xml.items.item[i].img[j],j));
				}
				
				_itemArray.push(obj);
			}
			
			// add category view panel
			_categoryView = new CategoryView();
			_categoryView.y = 70;
			_categoryView.addEventListener(ScrollImageEvent.CHANGE_SELECT,onScrollImageChange);
			addChild(_categoryView);
			_categoryView.dataInit(_itemArray, _categoryStyle);
			
			// add photo view panel
			_imageView = new ImageView();
			addChild(_imageView);
			_imageView.dataInit(_photoStyle);
			
			// open image
			_categoryView.startOpen();
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/** 
		 *  load xml files complete
		 */
		private function onLoadXmlComplete(evt:LoadDataEvent):void
		{
			_xml = evt.data;
			analyzeXml();
		}
		
		/**
		 *  show you select photo
		 */
		private function onScrollImageChange(evt:ScrollImageEvent):void
		{
			//trace(evt.data.sId,"change image");
			if(_imageView) _imageView.show(evt.data.array,evt.data.sId);
		}
	}
}