﻿package com.activetofocus.photoviewer.components
{
	import cn.com.aven.Guider;
	import com.activetofocus.photoviewer.events.CategoryTitleEvent;
	import flash.text.TextField;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextFormat;
	
	/**
	 * CategoryTitle
	 *
	 * @author activetofocus team
	 * @since  2010-05-22
	 */
	public class CategoryTitle extends MovieClip
	{
		//--------------------------------------
		//  Variables
		//--------------------------------------
		
		/**
		 *  style
		 */
		private var _seleteColor:uint = 0xFFFFFF; // selete text color
		private var _defaultColor:uint = 0x999999; // mouse over color
		private var _glowValue:Number = 8;
		private var _delayTime:Number = 0.3;// effect delay time
		private var _isClick:Boolean;// whether can click
		
		/**
    	 *  constructor
     	 */
		public function CategoryTitle()
		{
			init();
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		
		/**
		 *  data init
		 */
		private function init():void
		{
			txt.mouseEnabled = false;
			//setBackground();
			this.buttonMode = true;
			this.addEventListener(MouseEvent.CLICK,onCategoryTitleMouseClick);
			this.addEventListener(MouseEvent.MOUSE_OVER,onCategoryTitleMouseOver);
			this.addEventListener(MouseEvent.MOUSE_OUT,onCategoryTitleMouseOut);
			this.text = "";
		}
		
		/**
		 *  initial data
		 */
		public function dataInit(categoryStyle:Object=null):void
		{
			if(categoryStyle)
			{
				
				_seleteColor  = categoryStyle.titleseletecolor;
				_defaultColor = categoryStyle.titledefaultcolor
				_delayTime    = categoryStyle.titledelaytime;
				_glowValue    = categoryStyle.titleglow;
				//trace(categoryStyle.titleseletecolor,categoryStyle.titledefaultcolor,_glowValue)
				this.text = txt.text;
			}
		}

		/**
		 *  change title text
		 */
		public function set text(value:String):void
		{
			txt.text = value;
			txt.filters = null;
			txt.setTextFormat(new TextFormat("ChunkFive",23,_defaultColor));
			setBackground();
		}
		
		/**
		 *  change title show state
		 */
		public function changeSelete(value:Boolean):void
		{
			_isClick = value;
			if(_isClick)
			{
				txt.setTextFormat(new TextFormat("ChunkFive",23,_seleteColor));
				Guider.to(txt,{glow:{color:_seleteColor,strength:1,alphaFrom:0,alphaTo:.8,blurXFrom:0,blurXTo:_glowValue,blurYFrom:0,blurYTo:_glowValue}},_delayTime);
			}
			else
			{
				this.text = txt.text;
			}
		}
		
		/**
		 *  set title background area
		 */
		private function setBackground():void
		{
			this.graphics.clear();
			this.graphics.beginFill(0xff0000,0);
			this.graphics.drawRect(0,0,txt.textWidth + 5,txt.height);
			this.graphics.endFill();
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/**
		 *  button mouse click
		 */
		private function onCategoryTitleMouseClick(evt:MouseEvent):void
		{
			if(_isClick) return;
			dispatchEvent(new CategoryTitleEvent(CategoryTitleEvent.CHANGE_SELECT));
		}
		
		/**
		 *  button mouse over
		 */
		private function onCategoryTitleMouseOver(evt:MouseEvent):void
		{
			if(_isClick) return;
			Guider.to(txt,{glow:{color:_defaultColor,strength:1,alphaFrom:0,alphaTo:.8,blurXFrom:0,blurXTo:_glowValue,blurYFrom:0,blurYTo:_glowValue}},_delayTime);
		}
		
		/**
		 *  button mouse out
		 */
		private function onCategoryTitleMouseOut(evt:MouseEvent):void
		{
			if(_isClick) return;
			txt.filters = null;
		}
			
	}
}