﻿package com.activetofocus.photoviewer.components
{
	import caurina.transitions.Tweener;
	import com.activetofocus.photoviewer.events.ControlBtnComponentEvent;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	
	/**
	 * ControlBtnComponent
	 *
	 * @author activetofocus team
	 * @since  2010-05-22
	 */
	public class ControlBtnComponent extends MovieClip
	{
		//--------------------------------------
		//  Variables
		//--------------------------------------
		
		/**
		 *  style
		 */
		private var _spacing:Number = 5;// button spacing
		private var _scaleVal:Number = 1.3;// mouse over button 
		private var _alpha:Number = 0.5;// mouse over button,other button show alpha value
		private var _delay:Number = 0.5;// tween delay time
		
		
		private var _btnArray:Array;
		/**
    	 *  constructor
     	 */
		public function ControlBtnComponent()
		{
			
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		/**
		 *  data init
		 */
		public function dataInit():void
		{
			_btnArray = [cble_btn,cbzi_btn,cbzo_btn,cblr_btn,cbrr_btn,cbri_btn];
			for(var i:int=0; i<_btnArray.length; i++)
			{
				_btnArray[i].x = i* (_btnArray[i].width + _spacing);
				addAllEvent(_btnArray[i]);
			}
		}
		
		/**
		 *  set object button mode and add mouse event
		 */
		private function addAllEvent(obj:*):void
		{
			obj.buttonMode = true;
			obj.addEventListener(MouseEvent.MOUSE_OVER,onBtnMouseOver);
			obj.addEventListener(MouseEvent.MOUSE_OUT,onBtnMouseOut);
			obj.addEventListener(MouseEvent.CLICK,onBtnMouseClick);
		}
		
		/**
		 *  set alpha
		 */
		private function setAlpah(obj:* = null,bool:Boolean = false):void
		{
			for(var i:int=0; i<_btnArray.length; i++)
			{
				if(!bool)
				{
					if(obj != _btnArray[i]) Tweener.addTween(_btnArray[i],{time:_delay,alpha:_alpha});
				}
				else
				{
					Tweener.addTween(_btnArray[i],{time:_delay,alpha:1});
				}
			}
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/**
		 *  button mouse click
		 */
		private function onBtnMouseClick(evt:MouseEvent):void
		{
			dispatchEvent(new ControlBtnComponentEvent(ControlBtnComponentEvent.CHANGE_SELECT,evt.currentTarget.name));
		}
		
		/**
		 *  button mouse over
		 */
		private function onBtnMouseOver(evt:MouseEvent):void
		{
			evt.currentTarget.gotoAndStop(2);
			Tweener.addTween(evt.currentTarget,{time:_delay,scaleX:_scaleVal,scaleY:_scaleVal});
			setAlpah(evt.currentTarget);
		}
		
		/**
		 *  button mouse out
		 */
		private function onBtnMouseOut(evt:MouseEvent):void
		{
			evt.currentTarget.gotoAndStop(1);
			Tweener.addTween(evt.currentTarget,{time:_delay,scaleX:1,scaleY:1});
			setAlpah(null,true);
		}
			
	}
}