﻿package com.activetofocus.photoviewer.model
{
	
	/**
	 * GalleryVO
	 *
	 * @author activetofocus team
	 * @since  2010-05-22
	 */
	public class GalleryVO
	{
		/**
		 *  gallery pic id
		 */
		private var _id:int;
		
		/**
		 *  gallery pic title 
		 */
		private var _title:String;
		
		/**
		 *  gallery pic desc 
		 */
		private var _desc:String;
		
		/**
		 *  gallery pic icon path 
		 */
		private var _icon:String;
		
		/**
		 *  gallery pic path 
		 */
		private var _src:String;
		
		/**
		 *  gallery pic width 
		 */
		private var _wd:Number;
		
		/**
		 *  gallery pic height 
		 */
		private var _hg:Number;
		
		/**
		 *
		 */
		public function GalleryVO(data:* = null,id:int = 0)
		{
			_id     =  id;
			_title  =  data.@title || "";
			_desc   =  data || "";
			_icon   =  data.@icon || "";
			_src    =  data.@src || "";
			_wd 	=  data.@width ? Number(data.@width) : 0;
			_hg 	=  data.@width ? Number(data.@height) : 0;
		}
		
		
		//--------------------------------------
		//  Get Function
		//--------------------------------------
		
		/**
		 *  get gallery pic id
		 */
		public function get id():int
		{
			return _id;
		}
		
		/**
		 *  get gallery pic title
		 */
		public function get title():String
		{
			return _title;
		}
		
		/**
		 *  get gallery pic desc
		 */
		public function get desc():String
		{
			return _desc;
		}
		
		/**
		 *  get gallery pic icon path
		 */
		public function get icon():String
		{
			return _icon;
		}
		
		/**
		 *  get gallery pic path
		 */
		public function get src():String
		{
			return _src;
		}
		
		/**
		 *  get gallery pic width
		 */
		public function get width():Number
		{
			return _wd;
		}
		
		/**
		 *  get gallery pic height
		 */
		public function get height():Number
		{
			return _hg;
		}
		
	}
}