﻿package com.activetofocus.photoviewer.view
{
	import cn.com.aven.*;
	import caurina.transitions.Tweener;
	import com.activetofocus.photoviewer.components.CategoryTitle;
	import com.activetofocus.photoviewer.events.CategoryTitleEvent;
	import com.activetofocus.photoviewer.events.ScrollImageEvent;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.events.MouseEvent;
	import flash.display.StageDisplayState;
	
	/**
	 * CategoryMain
	 *
	 * @author activetofocus team
	 * @since  2010-05-22
	 */
	public class CategoryMain extends MovieClip
	{
		
		//--------------------------------------
		//  Variables
		//--------------------------------------
		
		/**
		 *  category id
		 */
		private var _cId:int;
		
		/**
		 *  style data
		 */
		private var _categoryStyle:Object;
		private var _titleY:Number = 30;
		
		/**
		 *  other information
		 */ 
		private var _itemArray:Array;
		
		/**
		 *  other panel
		 */
		private var _categoryTitle:CategoryTitle; // category title panel
		private var _scrollImage:ScrollImage; // scroll image panle
		
		/**
   		 *  constructor
    	 */
		public function CategoryMain()
		{
			
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		
		/**
		 *  initial data
		 */
		public function dataInit(value:Array,cId:int,categoryStyle:Object=null):void
		{
			_cId = cId
			_itemArray = value;
			
			if(categoryStyle) _categoryStyle = categoryStyle;
			
			addItem();
		}
		
		/**
		 *  add all element
		 */
		private function addItem():void
		{
			_categoryTitle = new CategoryTitle();
			_categoryTitle.addEventListener(CategoryTitleEvent.CHANGE_SELECT,onChangeSelete);
			_categoryTitle.text = _itemArray[_cId].title;
			_categoryTitle.x = _titleY;
			addChild(_categoryTitle);
			_categoryTitle.dataInit(_categoryStyle);
			
			_scrollImage = new ScrollImage();
			_scrollImage.y = _categoryTitle.height + 5;
			_scrollImage.addEventListener(ScrollImageEvent.CHANGE_SELECT,onScrollImageChange);
			addChildAt(_scrollImage,0);
			_scrollImage.dataInit(_itemArray[_cId].galleryArr,_categoryStyle);
		}
		
		/**
		 *  category selete change 
		 */
		public function changeSelete(value:Boolean):void
		{
			_categoryTitle.changeSelete(value);
			_scrollImage.changeShow(value);
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/**
		 *  category title change selete
		 */
		private function onChangeSelete(evt:CategoryTitleEvent):void
		{
			//trace(_cId);
			dispatchEvent(new CategoryTitleEvent(CategoryTitleEvent.CHANGE_SELECT,_cId));
		}
		
		/**
		 *  image selete change
		 */
		private function onScrollImageChange(evt:ScrollImageEvent):void
		{
			//trace(evt.data.sId);
			dispatchEvent(new ScrollImageEvent(ScrollImageEvent.CHANGE_SELECT,{array:_itemArray[_cId].galleryArr,sId:evt.data.sId}));
		}
	}
}