﻿package com.activetofocus.photoviewer.view
{
	import cn.com.aven.*;
	import caurina.transitions.Tweener;
	import com.activetofocus.photoviewer.components.CategoryTitle;
	import com.activetofocus.photoviewer.events.CategoryTitleEvent;
	import com.activetofocus.photoviewer.events.ScrollImageEvent;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.events.MouseEvent;
	import flash.display.StageDisplayState;
	
	/**
	 * CategoryView
	 *
	 * @author activetofocus team
	 * @since  2010-05-22
	 */
	public class CategoryView extends MovieClip
	{
		
		//--------------------------------------
		//  Variables
		//--------------------------------------
		
		/**
		 *  style data
		 */
		private var _categoryStyle:Object;// all style
		
		private var _itemSpacing:Number = 50;// menu spacing
		private var _imageHeight:Number = 120;// image scroll area height
		private var _delayTime:Number = 0.5;// effect delay time
		/**
		 *  other information
		 */ 
		private var _itemArray:Array;// photo item array
		private var _categoryMainArray:Array;// category main panel array
				
		/**
   		 *  constructor
    	 */
		public function CategoryView()
		{
			init();
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		/**
		 *  initial data
		 */
		private function init():void
		{
			
		}
		
		/**
		 *  data init
		 */
		public function dataInit(value:Array, categoryStyle:Object = null):void
		{
			_itemArray = value;
			
			if(categoryStyle)
			{
				_categoryStyle = categoryStyle;
				_itemSpacing   = _categoryStyle.categorymenuspacing;
				_imageHeight   = _categoryStyle.categoryimageheigh;
				_delayTime     = _categoryStyle.categoryeffectdelay;
			}
			
			addItem();
		}
		
		/**
		 *  open first category
		 */
		public function startOpen():void
		{
			if(_categoryMainArray && _categoryMainArray.length != 0) onChangeSelete({data:0})
		}
		
		/**
		 *   add CategoryMain item
		 */
		private function addItem():void
		{
			_categoryMainArray = [];
			for(var i:int=0; i<_itemArray.length; i++)
			{
				var cm:CategoryMain = new CategoryMain();
				cm.addEventListener(CategoryTitleEvent.CHANGE_SELECT,onChangeSelete);
				cm.addEventListener(ScrollImageEvent.CHANGE_SELECT,onScrollImageChange);
				cm.y = i*_itemSpacing;
				addChild(cm);
				cm.dataInit(_itemArray,i,_categoryStyle);
				_categoryMainArray.push(cm);
			}
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		/**
		 *  category menu change selete
		 */
		private function onChangeSelete(evt:*):void
		{
			for(var i:int=0; i<_categoryMainArray.length; i++)
			{
				_categoryMainArray[i].changeSelete(evt.data == i);
				
				if(i <= evt.data)
				{
					Tweener.addTween(_categoryMainArray[i],{time:_delayTime,y:i*_itemSpacing});
				}
				else
				{
					Tweener.addTween(_categoryMainArray[i],{time:_delayTime,y:i*_itemSpacing + _imageHeight});
				}
			}
		}
		
		/**
		 *  scroll images change select
		 */
		private function onScrollImageChange(evt:ScrollImageEvent):void
		{
			//trace(evt.data.sId);
			dispatchEvent(new ScrollImageEvent(ScrollImageEvent.CHANGE_SELECT,{array:evt.data.array,sId:evt.data.sId}));
		}
	}
}