﻿package com.activetofocus.photoviewer.view
{
	import com.activetofocus.utils.LoaderData;
	import com.activetofocus.events.LoadDataEvent;
	import com.activetofocus.photoviewer.events.ControlBtnPanelEvent;
	import com.activetofocus.photoviewer.components.ControlBtnComponent;
	import com.activetofocus.photoviewer.events.ControlBtnComponentEvent;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Loader;
	/**
	 * ControlBtnPanel
	 *
	 * @author activetofocus team
	 * @since  2010-04-04
	 */
	public class ControlBtnPanel extends Sprite
	{
		//--------------------------------------
		//  Variables
		//--------------------------------------
		
		/**
		 *  component
		 */
		private var _cbComp:ControlBtnComponent;
		
		/**
    	 *  constructor
     	 */
		public function ControlBtnPanel()
		{
			
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		public function dataInit():void
		{
			addControlBtn();
		}
		
		/**
		 *  add control btn
		 */
		private function addControlBtn():void
		{
			_cbComp = new ControlBtnComponent();
			_cbComp.x = -Number(_cbComp.width/2);
			_cbComp.y = -Number(_cbComp.height/2);
			_cbComp.addEventListener(ControlBtnComponentEvent.CHANGE_SELECT,onControlBtnChangeSelect);
			_cbComp.dataInit();
			addChild(_cbComp);
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/**
		 *  select control button
		 */
		private function onControlBtnChangeSelect(evt:ControlBtnComponentEvent):void
		{
			dispatchEvent(new ControlBtnPanelEvent(ControlBtnPanelEvent.CHANGE_SELECT,evt.data));
		}
	}
}