﻿package com.activetofocus.photoviewer.view
{
	import cn.com.aven.*;
	import com.activetofocus.utils.Resizer;
	import caurina.transitions.Tweener;
	import com.activetofocus.photoviewer.view.PhotoMain;
	import com.activetofocus.photoviewer.events.ControlBtnPanelEvent;
	import flash.system.LoaderContext; 
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.events.MouseEvent;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObject;
	import flash.events.ProgressEvent;
	import flash.ui.Mouse;
	
	/**
	 * ImageView
	 *
	 * @author activetofocus team
	 * @since  2010-05-22
	 */
	public class ImageView extends MovieClip
	{
		
		//--------------------------------------
		//  Variables
		//--------------------------------------
		/**
		 *  style data
		 */
		private var _photoStyle:Object;
		private var _bgColor:uint = 0x1a1a1a;
		private var _bgAlpha:Number = 0.8;
		private var _data:Array;
		private var _nowInt:int;
		private var _delayTime:Number = 0.5;
		/**
		 *  other panel
		 */
		private var _imagePanel:PhotoMain;// image show panel
		private var _controlBtnPanel:ControlBtnPanel;// control button panel
		private var _closeBtn:CloseBtn;// close button
		private var _bgPanel:Sprite;// background panel
		/**
   		 *  constructor
    	 */
		public function ImageView()
		{
			init();
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		/**
		 *  initial data
		 */
		private function init():void
		{
			_bgPanel = new Sprite();
			_bgPanel.addEventListener(MouseEvent.CLICK,onBgPanelMouseClick);
			_bgPanel.addEventListener(MouseEvent.MOUSE_OVER,onBgPanelMouseOver);
			_bgPanel.addEventListener(MouseEvent.MOUSE_MOVE,onBgPanelMouseMove);
			_bgPanel.addEventListener(MouseEvent.MOUSE_OUT,onBgPanelMouseOut);
			addChild(_bgPanel);
			
			_closeBtn = new CloseBtn();
			_closeBtn.mouseChildren = false;
			_closeBtn.mouseEnabled = false;
			_closeBtn.visible = false;
			_bgPanel.addChild(_closeBtn);
		}
		
		/**
		 *  data init
		 */
		public function dataInit(photoStyle:Object = null):void
		{
			if(photoStyle)
			{
				_photoStyle = photoStyle;
				_delayTime  = _photoStyle.delaytime;
				_bgColor    = _photoStyle.bgcolor;
				_bgAlpha    = _photoStyle.bgalpha;
			}
			this.visible = false;
			
			this.stage.addEventListener(Event.RESIZE,onResize);

			_imagePanel = new PhotoMain();
			addChild(_imagePanel);
			_imagePanel.dataInit(_photoStyle);
			
			_controlBtnPanel = new ControlBtnPanel();
			addChild(_controlBtnPanel);
			_controlBtnPanel.addEventListener(ControlBtnPanelEvent.CHANGE_SELECT,onControlBtnPanelChangeSelect);
			_controlBtnPanel.dataInit();
			
			Resizer.to(_imagePanel,Resizer.CENTER,true,{y: - 28},200);
			Resizer.to(_controlBtnPanel,Resizer.CENTER_BOTTOM,true,{x:14,y:-30},200);
			
			onResize(null);
		}
		
		/**
		 *  show image
		 */
		public function show(arr:Array,i:int):void
		{
			_data = arr;
			_nowInt = i;
			
			_imagePanel.addImage(_data[i]);
			Tweener.addTween(this,{time:_delayTime,alpha:1});
			
			onChangeViewState(true);
		}
		
		/**
		 *  change image view state
		 */
		private function onChangeViewState(bool:Boolean = false):void
		{
			this.visible = bool;
			if(bool) _imagePanel.removeImage();
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/**
		 *  stage resize
		 */
		private function onResize(evt:Event):void
		{
			if(!_bgPanel) return;
			_bgPanel.graphics.clear();
			_bgPanel.graphics.beginFill(_bgColor,_bgAlpha);
			_bgPanel.graphics.drawRect(0,0,this.stage.stageWidth,this.stage.stageHeight);
			_bgPanel.graphics.endFill();
		}
		
		/**
		 *  control button panel change data
		 */
		private function onControlBtnPanelChangeSelect(evt:ControlBtnPanelEvent):void
		{
			//trace(evt.data);
			if(evt.data == "cbzi_btn") _imagePanel.onImageZoom(true);
			if(evt.data == "cbzo_btn") _imagePanel.onImageZoom(false);
			if(evt.data == "cblr_btn") _imagePanel.onImageRotator(true);
			if(evt.data == "cbrr_btn") _imagePanel.onImageRotator(false);
			if(evt.data == "cble_btn")
			{
				_nowInt--;
				if(_nowInt < 0) _nowInt = _data.length-1;
				_imagePanel.addImage(_data[_nowInt]);
			}
			if(evt.data == "cbri_btn")
			{
				_nowInt++;
				if(_nowInt >= _data.length) _nowInt = 0;
				_imagePanel.addImage(_data[_nowInt]);
			}
		}
		
		/**
		 *  background panel mouse click
		 */
		private function onBgPanelMouseClick(evt:MouseEvent):void
		{
			Tweener.addTween(this,{time:_delayTime,alpha:0,onComplete:onChangeViewState});
		}
		
		/**
		 *  background panel mouse over
		 */
		private function onBgPanelMouseOver(evt:MouseEvent):void
		{
			Mouse.hide();
			_closeBtn.x = this.mouseX;
			_closeBtn.y = this.mouseY;
			_closeBtn.visible = true;
		}
		
		/**
		 *  background panel mouse move
		 */
		private function onBgPanelMouseMove(evt:MouseEvent):void
		{
			_closeBtn.x = this.mouseX;
			_closeBtn.y = this.mouseY;
		}
		
		/**
		 *  background panel mouse out
		 */
		private function onBgPanelMouseOut(evt:MouseEvent):void
		{
			_closeBtn.visible = false;
			Mouse.show();
		}
		
	}
}