﻿package com.activetofocus.photoviewer.view
{
	import cn.com.aven.*;
	import caurina.transitions.Tweener;
	import com.activetofocus.Preloader;
	import com.activetofocus.photoviewer.model.GalleryVO;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.events.MouseEvent;
	import flash.display.StageDisplayState;
	import flash.events.ProgressEvent;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	
	/**
	 * PhotoMain
	 *
	 * @author activetofocus team
	 * @since  2010-05-22
	 */
	public class PhotoMain extends MovieClip
	{
		
		//--------------------------------------
		//  Variables
		//--------------------------------------
		
		/**
		 *  style data
		 */
		private var _borderThickness:Number = 6;//image border width
		private var _delay:Number = 300 ; // image loader delay time
		private var _bgColor:uint = 0x1a1a1a;// background color
		private var _bgAlpha:Number = 1;// background alpha
		
		/**
		 *  other information
		 */ 
		private var _galleryData:GalleryVO;// image data value

		private var _preloader:Preloader;// preloaser
		
		private var loader:Loader;// loader
		
		private var imageObj:*;// last show object
		private var imgGuider:Guider;// guider object
		
		private var _scaleInt:int;// now image scaleX,scaleY value
		private var _rotateInt:int;// now image rotate dic value
		
		/**
		 *  other panel
		 */
		private var _imagePanel:Sprite;
		private var _backgroundPanel:Sprite;
		
		/**
   		 *  constructor
    	 */
		public function PhotoMain()
		{
			init();
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		/**
		 *  initial data
		 */
		private function init():void
		{
			_imagePanel = new Sprite();
			addChild(_imagePanel);
			
			// add photo background
			_backgroundPanel = new Sprite();
			_imagePanel.addChild(_backgroundPanel);
			
			_imagePanel.buttonMode = true;
			_imagePanel.addEventListener(MouseEvent.MOUSE_DOWN,onImageMouseDown);
		}
		
		/**
		 *  data init
		 */
		public function dataInit(photoStyle:Object = null):void
		{
			if(photoStyle)
			{
				//trace(photoStyle.imagebgcolor);
				_bgColor    = photoStyle.imagebgcolor;
				_bgAlpha    = photoStyle.imagebgalpha;
				_delay      = Number(photoStyle.imagedelaytime * 1000);
				_borderThickness = photoStyle.imagebgborderthickness;
			}
		}
		
		/**
		 *  add new image
		 */
		public function addImage(gv:GalleryVO):void
		{
			_galleryData = gv;
			
			_rotateInt = 0;
			_scaleInt = 2;
			
			Guider.to(_imagePanel,{tween:{rotation:0,scaleX:1,scaleY:1,x:0,y:0}},_delay);
			Guider.to(_backgroundPanel,{tween:{alpha:0}},_delay);
			if(_preloader) Guider.to(_preloader,{tween:{alpha:0}},_delay);
			// delete loader
			if(loader) 
			{
				try
				{
					loader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderItemError);
					loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS,onLoaderProgress);
					loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,onLoaderItemComplete);
					loader.unload();
				}catch(e:Error){};
			}

			// add image
			if(!imageObj) 
			{
				imageObj = new Sprite();
				onGuiderBackgroundComplete(null);
			}
			else
			{
				if(imgGuider) imgGuider.pause();
				imgGuider = Guider.to(imageObj,{tween:{alpha:0}},_delay);
				imgGuider.addEventListener(GuiderEvent.GuiderEvent_COMPLETE,onGuiderBackgroundComplete);
			}
		}
		
		public function removeImage():void
		{
			try
			{
				_backgroundPanel.graphics.clear();
				imageObj.removeChildAt(0);
			}catch(e:Error){};
		}
		
		/**
		 *  left,right rotate image
		 */
		public function onImageRotator(bool:Boolean):void
		{
			if(bool)
			{
				_rotateInt--;
			}
			else
			{
				_rotateInt++;
			}
			if(_rotateInt == 4 || _rotateInt == -4) _rotateInt = 0;
			
			Guider.to(_imagePanel,{tween:{rotation:(_rotateInt)*90,x:0,y:0}},_delay);
			
		}
		
		/**
		 *  zoom in,out image
		 */
		public function onImageZoom(bool:Boolean):void
		{
			if(bool)
			{
				if(_scaleInt - 1 <= 0) return;
				_scaleInt--;
			}
			else
			{
				if(_scaleInt + 1 >= 5) return;
				_scaleInt++;
			}
			Guider.to(_imagePanel,{tween:{scaleX:Number(_scaleInt * 0.5),scaleY:Number(_scaleInt * 0.5),x:0,y:0}},_delay);
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/**
		 *  loader item error
		 */
		private function onLoaderItemError(evt:IOErrorEvent):void
		{
			evt.currentTarget.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderItemError);
			evt.currentTarget.removeEventListener(Event.COMPLETE,onLoaderItemComplete);
			trace("item load error");
		}
		
		/**
		 *  loader item complete
		 */
		private function onLoaderItemComplete(evt:Event):void
		{
			evt.currentTarget.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderItemError);
			evt.currentTarget.removeEventListener(Event.COMPLETE,onLoaderItemComplete);
			
			if(_galleryData.width != 0) loader.width  = _galleryData.width;
			if(_galleryData.height != 0) loader.height = _galleryData.height;
			
			var bmd:BitmapData = new BitmapData(loader.width,loader.height);
			bmd.draw(loader);
			
			var bm:Bitmap = new Bitmap(bmd,"auto",true);
			bm.x = -bm.width/2;
			bm.y = -bm.height/2;
			
			try
			{
				imageObj.removeChildAt(0);
			}catch(e:Error){};
			
			imageObj.alpha = 0;
			imageObj.addChild(bm);
			
			_imagePanel.addChild(imageObj);
			
			//_backgroundPanel.alpha = 0;
			_backgroundPanel.graphics.clear();
			_backgroundPanel.graphics.beginFill(_bgColor,_bgAlpha);
			_backgroundPanel.graphics.drawRect(-(bm.width + 2*_borderThickness)/2,-(bm.height + 2*_borderThickness)/2,bm.width + 2*_borderThickness,bm.height + 2*_borderThickness);
			_backgroundPanel.graphics.endFill();
			
			Guider.to(_backgroundPanel,{tween:{alpha:1}},_delay);
			Guider.to(imageObj,{tween:{alpha:1}},_delay);
		}
		
		/**
		 *  image load progress
		 */
		private function onLoaderProgress(evt:ProgressEvent):void
		{
			if(_preloader)
			{
				_preloader.txt.text = Math.floor(Number(evt.bytesLoaded/evt.bytesTotal)*100).toString();
				if(evt.bytesLoaded == evt.bytesTotal) 
				{
					_imagePanel.removeChild(_preloader);
					_preloader = null;
				}
			}
		}
				
		/**
		 *  image background guide complete event
		 */
		private function onGuiderBackgroundComplete(evt:GuiderEvent):void
		{
			if(evt != null) evt.currentTarget.removeEventListener(GuiderEvent.GuiderEvent_COMPLETE,onGuiderBackgroundComplete);
			
			_backgroundPanel.graphics.clear();
			try
			{
				imageObj.removeChildAt(0);
			}catch(e:Error){};
			
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR,onLoaderItemError);
			loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS,onLoaderProgress);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onLoaderItemComplete);
			loader.load(new URLRequest(_galleryData.src));
			
			// add preloader
			if(_preloader) _imagePanel.removeChild(_preloader);
			_preloader = new Preloader();
			_preloader.txt.mouseEnabled = false;
			_imagePanel.addChild(_preloader);
		}
		
		/**
		 *  image start drag
		 */
		private function onImageMouseDown(evt:MouseEvent):void
		{
			_imagePanel.startDrag();
			this.stage.addEventListener(MouseEvent.MOUSE_UP,onImageMouseUp);
		}
		
		/**
		 *  image stop drag
		 */
		private function onImageMouseUp(evt:MouseEvent):void
		{
			this.stage.removeEventListener(MouseEvent.MOUSE_UP,onImageMouseUp);
			_imagePanel.stopDrag();
		}

	}
}