﻿package com.activetofocus.photoviewer.view
{
	import cn.com.aven.*;
	import caurina.transitions.Tweener;
	import com.activetofocus.photoviewer.components.CategoryTitle;
	import com.activetofocus.photoviewer.events.ScrollImageEvent;
	import com.activetofocus.Preloader;
	import flash.system.LoaderContext; 
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.events.MouseEvent;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObject;
	import flash.events.ProgressEvent;
	
	/**
	 * ScrollImage
	 *
	 * @author activetofocus team
	 * @since  2010-05-22
	 */
	public class ScrollImage extends MovieClip
	{
		
		//--------------------------------------
		//  Variables
		//--------------------------------------
		
		/**
		 *  whether delete all image
		 */
		private var _isDelete:Boolean;
		
		/**
		 *  style data
		 */
		private var _stateDelayTime:Number = 0.5;// show/delete iamge effect delay time
		private var _scrollDelayTime:Number = 0.5;// scroll delay time
		private var _scrollSpacing:Number = 80;// scroll start point value
		
		/**
		 *  other information
		 */ 
		private var _itemArray:Array;
		
		private var _imgArray:Array;
		
		private var _nowLoaderInt:int = -1;
		
		private var loader:Loader;// currently loaded objects
		
		/**
		 *  other panel
		 */
		private var _categoryTitle:CategoryTitle;
		
		private var _mask:Sprite;
		
		private var _imagePanel:Sprite;
		
		private var _preloader:Preloader;
		
		/**
   		 *  constructor
    	 */
		public function ScrollImage()
		{
			init();
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		/**
		 *  initial data
		 */
		private function init():void
		{
			_imagePanel = new Sprite();
			_imagePanel.addEventListener(MouseEvent.MOUSE_MOVE,onImagePanelMouseMove);
			addChild(_imagePanel);
			
			_mask = new Sprite();
			addChild(_mask);
			_mask.scaleY = 0;
			this.mask = _mask;
		}
		
		/**
		 *  data init
		 */
		public function dataInit(value:Array,categoryStyle:Object=null):void
		{
			this.stage.addEventListener(Event.RESIZE,onResize);
			_itemArray = value;
			if(categoryStyle)
			{
				_stateDelayTime  = categoryStyle.categoryeffectdelay;
				_scrollDelayTime = categoryStyle.imagescrolldelaytime;
				_scrollSpacing   = categoryStyle.imagescrollspacing;
			}
			onResize(null);
		}
		
		/**
		 *  change show state
		 */
		public function changeShow(value:Boolean):void
		{
			if(value)
			{
				_isDelete = false;
				Tweener.addTween(_mask,{scaleY:1,time:_stateDelayTime,onComplete:startAddImg});
			}
			else
			{
				_isDelete = true;
				Tweener.addTween(_mask,{scaleY:0,time:_stateDelayTime,onComplete:onDeleteAllImage});
			}
		}
		
		/**
		 *  start delete all image
		 */
		private function onDeleteAllImage():void
		{
			_nowLoaderInt = -1;
			_imagePanel.x = 0;
			if(loader) 
			{
				loader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderMinImageErrorEvent);
				loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,onLoaderMinImageCompleteEvent);
				loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS,onProgressEvent);
				loader.unload();
			}
			if(_preloader)
			{
				removeChild(_preloader);
				_preloader = null;
			}
			if(!_imgArray || _imgArray.length == 0) return;

			for(var i:int=0; i<_imgArray.length; i++)
			{
				if(_imgArray[i]) _imagePanel.removeChild(_imgArray[i]);
			}
			_imgArray = null;
			
		}
		
		/**
		 *  start add all image
		 */
		private function startAddImg():void
		{
			if(_isDelete) onDeleteAllImage();
			
			_nowLoaderInt++;
			
			if(!_imgArray) _imgArray = [];
			if(_nowLoaderInt >= _itemArray.length) return;
			
			if(_preloader) removeChild(_preloader);
			_preloader = new Preloader();
			_preloader.txt.mouseEnabled = false;
			_preloader.scaleX = _preloader.scaleY = 0.8;
			_preloader.x = _imagePanel.width + 50;
			_preloader.y = 60;
			addChild(_preloader);
			//trace(_nowLoaderInt,"load",_imagePanel.x);
			loader       =  new Loader();
			loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS,onProgressEvent);
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR,onLoaderMinImageErrorEvent);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onLoaderMinImageCompleteEvent);
			loader.load(new URLRequest(_itemArray[_nowLoaderInt].icon),new LoaderContext(true));
		}
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/**
		 *  stage resize
		 */
		private function onResize(evt:Event):void
		{
			//trace(123232);
			_mask.graphics.clear();
			_mask.graphics.beginFill(0xff0000,1);
			_mask.graphics.drawRect(0,0,this.stage.stageWidth,120);
			_mask.graphics.endFill();
			
			if(_imagePanel) Tweener.addTween(_imagePanel,{x:0,time:0.5});
		}
		
		/**
		 *  loader image error
		 */
		private function onLoaderMinImageErrorEvent(evt:IOErrorEvent):void
		{
			loader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderMinImageErrorEvent);
			loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,onLoaderMinImageCompleteEvent);
			loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS,onProgressEvent);
			
			startAddImg();
		}
		
		/**
		 *  loader image complete
		 */
		private function onLoaderMinImageCompleteEvent(evt:Event):void
		{
			loader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderMinImageErrorEvent);
			loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,onLoaderMinImageCompleteEvent);
			loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS,onProgressEvent);
			
			var mc:MovieClip = new MovieClip();
			_imgArray.push(mc);
			
			var bmp:BitmapData = new BitmapData(loader.width,loader.height);
			bmp.draw(loader);
			var bm:Bitmap = new Bitmap(bmp,"auto",true);
			
			mc.name = _nowLoaderInt.toString();
			mc.buttonMode = true;
			mc.alpha = 0.4;
			mc.addChild(bm);
			mc.addEventListener(MouseEvent.MOUSE_OVER,onImageMouseOver);
			mc.addEventListener(MouseEvent.MOUSE_OUT,onImageMouseOut);
			mc.addEventListener(MouseEvent.CLICK,onImageMouseClick);
			mc.scaleX = mc.scaleY = 120/this.loader.height;
			mc.x = _imagePanel.width;
			
			_imagePanel.addChild(mc);
			//trace(_nowLoaderInt,"complete",_imagePanel.x);
			startAddImg();
		}
		
		/**
		 *   load image progress
		 */
		private function onProgressEvent(evt:ProgressEvent):void
		{
			if(_preloader)
			{
				_preloader.txt.text = Math.floor(Number(evt.bytesLoaded/evt.bytesTotal)*100).toString();
				if(evt.bytesLoaded == evt.bytesTotal) 
				{
					removeChild(_preloader);
					_preloader = null;
				}
			}
		}
		
		/**
		 *  image mouse click
		 */
		private function onImageMouseClick(evt:MouseEvent):void
		{
			//trace(int(evt.currentTarget.name));
			dispatchEvent(new ScrollImageEvent(ScrollImageEvent.CHANGE_SELECT,{sId:int(evt.currentTarget.name)}));
		}
		
		/**
		 *  image mouse over
		 */
		private function onImageMouseOver(evt:MouseEvent):void
		{
			Tweener.addTween(evt.currentTarget,{alpha:1,time:0.5});
		}
		
		/**
		 *  image mouse out
		 */
		private function onImageMouseOut(evt:MouseEvent):void
		{
			Tweener.addTween(evt.currentTarget,{alpha:0.4,time:0.5});
		}
		
		/**
		 *  image panel scroll event
		 */
		private function onImagePanelMouseMove(evt:MouseEvent):void
		{
			if(_imagePanel.width < this.stage.stageWidth) return;
			
			var k:Number;
			if(this.mouseX <_scrollSpacing )  
			{
				k = 0;
			}
			else
			if(this.mouseX > this.stage.stageWidth -_scrollSpacing)
			{
				k = this.stage.stageWidth - _imagePanel.width;
			}
			else
			{
				k = - Number(this.mouseX -_scrollSpacing) / (this.stage.stageWidth -_scrollSpacing * 2) * (_imagePanel.width - this.stage.stageWidth);
				
				if(k > 0 ) k = 0;
				
				if(k < this.stage.stageWidth - _imagePanel.width) k = this.stage.stageWidth - _imagePanel.width;
			}
			//trace(this.mouseX,k)
			Tweener.addTween(_imagePanel,{x:k,time:_scrollDelayTime});
		}
		
	}
}