﻿package com.activetofocus.utils
{
	import com.activetofocus.events.LoadDataEvent;
	import flash.events.EventDispatcher;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.Loader;
	
	/**
	 * LoadXmlData 
	 *
	 * @author activetofocus team
	 * @since  2010-04-03
	 */
	public class LoadXmlData extends EventDispatcher
	{
		//--------------------------------------
		//  Variables
		//--------------------------------------

		/**
    	 *  constructor
     	 */
		public function LoadXmlData()
		{
			
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		
		/**
		 *  start loader xml file
		 */
		public function load(path:String):void
		{
			var loader : URLLoader   = new URLLoader();
			loader.addEventListener(IOErrorEvent.IO_ERROR,onLoaderErrorEvent);
			loader.addEventListener(Event.COMPLETE,onLoaderCompleteEvent);
			loader.load(new URLRequest(path));
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/**
		 *  loader xml file error
		 */
		private function onLoaderErrorEvent(evt:IOErrorEvent):void
		{
			evt.currentTarget.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderErrorEvent);
			evt.currentTarget.removeEventListener(Event.COMPLETE,onLoaderCompleteEvent);
			dispatchEvent(new LoadDataEvent(LoadDataEvent.LOAD_ERROR));
			trace("xml files load path error");
		}
		
		/**
		 *  loader xml file complete
		 */
		private function onLoaderCompleteEvent(evt:Event):void
		{
			evt.currentTarget.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderErrorEvent);
			evt.currentTarget.removeEventListener(Event.COMPLETE,onLoaderCompleteEvent);
			dispatchEvent(new LoadDataEvent(LoadDataEvent.LOAD_COMPLETE,new XML(evt.currentTarget.data)));
		}
	}
}