﻿package com.activetofocus.utils
{
	import com.activetofocus.events.LoadDataEvent;
	import flash.events.EventDispatcher;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.display.Loader;
	
	/**
	 * LoaderData 
	 *
	 * @author activetofocus team
	 * @since  2010-04-03
	 */
	public class LoaderData extends EventDispatcher
	{
		//--------------------------------------
		//  Variables
		//--------------------------------------

		private var _params:*;
		
		/**
    	 *  constructor
     	 */
		public function LoaderData()
		{
			
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		
		/**
		 *  start loader xml file
		 */
		public function load(path:String,params:* = null):void
		{
			_params = params;
			var loader : Loader   = new Loader();
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR,onLoaderErrorEvent);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onLoaderCompleteEvent);
			loader.load(new URLRequest(path));
		}
		
		//--------------------------------------
		//  Event
		//--------------------------------------
		
		/**
		 *  loader xml file error
		 */
		private function onLoaderErrorEvent(evt:IOErrorEvent):void
		{
			evt.currentTarget.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderErrorEvent);
			evt.currentTarget.removeEventListener(Event.COMPLETE,onLoaderCompleteEvent);
			dispatchEvent(new LoadDataEvent(LoadDataEvent.LOAD_ERROR));
			trace("xml files load path error");
		}
		
		/**
		 *  loader xml file complete
		 */
		private function onLoaderCompleteEvent(evt:Event):void
		{
			evt.currentTarget.removeEventListener(IOErrorEvent.IO_ERROR,onLoaderErrorEvent);
			evt.currentTarget.removeEventListener(Event.COMPLETE,onLoaderCompleteEvent);
			dispatchEvent(new LoadDataEvent(LoadDataEvent.LOAD_COMPLETE,(_params != null ? {loader:evt.currentTarget.loader,params:_params} : evt.currentTarget.loader)));
		}
	}
}