﻿package com.activetofocus.utils
{
	import cn.com.aven.*;
	import flash.display.DisplayObject;
	import flash.events.Event;
	import flash.utils.Dictionary;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	
	
	/**
	 * Resizer 
	 *
	 * @author activetofocus team
	 * @since  2010-01-12
	 */
	public class Resizer
	{
		// Static constants 9 position
		public static const LEFT_TOP:String = "lefttop";
		public static const LEFT_CENTER:String = "leftcenter";
		public static const LEFT_BOTTOM:String = "leftbottom";
		public static const CENTER_TOP:String = "centertop";
		public static const CENTER:String = "center";
		public static const CENTER_BOTTOM:String = "centerbottom";
		public static const RIGHT_TOP:String = "righttop";
		public static const RIGHT_CENTER:String = "rightcenter";
		public static const RIGHT_BOTTOM:String = "rightbottom";
		
		// Whether there was an object the use of Resizer
		private static var _stage : Boolean; 
		
		//All the objects being used Resizer
		private static var _resizer :Dictionary;
		
		/**
		 *  Through the use of methods to achieve the proportion resize.
		 *  target     : Need to change the object
		 *  origin     : Whether the origin of target
		 *  offset     : Need to change the positon offset value .
		 *  align      : Shows the location of target
		 *  delayTime  : Transition delay time
		 *  easeFun    : Transition use function of effect
		 */
		public static function to(target:DisplayObject,align:String = "center",origin:Boolean = false,offset:Object = null,delayTime:Number = 1000,easeFun:Function = null):void
		{
			if(!_stage)
			{
				_stage = true;
				target.stage.align = StageAlign.TOP_LEFT;
	    		target.stage.scaleMode = StageScaleMode.NO_SCALE;
				target.stage.addEventListener(Event.RESIZE,onResizeEvent);
			}
			if(!_resizer) _resizer = new Dictionary();
			if(_resizer[target]) delete _resizer[target];
			
			_resizer[target] = {mc:target,origin:origin,align:align,offset:offset,delay:delayTime,ease:easeFun};
			
			onGuiderObj(_resizer[target]);
		}
		
		/**
		 *  Through the use of methods to remove object resize.
		 */
		public static function close(target:DisplayObject):void
		{
			if(_resizer[target]) delete _resizer[target];
		}
		
		/**
		 *  stage resize event
		 */
		private static function onResizeEvent(evt:Event):void
		{
			for each(var obj : Object in _resizer)
			{
				if(obj != null && obj.mc != null)
				{
					onGuiderObj(obj);
				}
			}
		}
		
		/**
		 *  Show the object began to change position
		 */
		private static function onGuiderObj(obj:Object):void
		{
			var _gx : Number;
			var _gy : Number;
			switch(obj.align)
			{
				case "lefttop" :
						_gx = 0;
						_gy = 0;
						break;
				case "righttop" :
						_gx = !obj.origin ? obj.mc.stage.stageWidth - obj.mc.width : obj.mc.stage.stageWidth;
						_gy = 0;
						break;
				case "centertop" :
						_gx = !obj.origin ? (obj.mc.stage.stageWidth - obj.mc.width)/2 : obj.mc.stage.stageWidth/2;
						_gy = 0;
						break;
				case "leftcenter" :
						_gx = 0;
						_gy = !obj.origin ? (obj.mc.stage.stageHeight - obj.mc.height)/2 : obj.mc.stage.stageHeight/2;
						break;
				case "rightcenter" :
						_gx = !obj.origin ? obj.mc.stage.stageWidth - obj.mc.width : obj.mc.stage.stageWidth;
						_gy = !obj.origin ? (obj.mc.stage.stageHeight - obj.mc.height)/2 : obj.mc.stage.stageHeight/2;
						break;
				case "center" :
						_gx = !obj.origin ? (obj.mc.stage.stageWidth - obj.mc.width)/2 : obj.mc.stage.stageWidth/2;
						_gy = !obj.origin ? (obj.mc.stage.stageHeight - obj.mc.height)/2 : obj.mc.stage.stageHeight/2;
						break;
				case "leftbottom" :
						_gx = 0;
						_gy = !obj.origin ? obj.mc.stage.stageHeight - obj.mc.height : obj.mc.stage.stageHeight;
						break;
				case "rightbottom" :
						_gx = !obj.origin ? obj.mc.stage.stageWidth - obj.mc.width : obj.mc.stage.stageWidth;
						_gy = !obj.origin ? obj.mc.stage.stageHeight - obj.mc.height : obj.mc.stage.stageHeight;
						break;
				case "centerbottom" :
						_gx = !obj.origin ? (obj.mc.stage.stageWidth - obj.mc.width)/2 : obj.mc.stage.stageWidth/2;
						_gy = !obj.origin ? obj.mc.stage.stageHeight - obj.mc.height : obj.mc.stage.stageHeight;
						break;
				default : trace("error");
			}
			if(obj.offset && obj.offset.x) _gx += Number(obj.offset.x);
			if(obj.offset && obj.offset.y) _gy += Number(obj.offset.y);
			Guider.to(obj.mc,{tween:{x:_gx,y:_gy},ease:obj.ease},obj.delay);
		}
	}
}