﻿package com.activetofocus.utils
{
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.geom.Point;
	import flash.display.GradientType;
	
	/**
	 * Xml Image Gallery Version 4.0
	 *
	 * @author activetofocus team
	 * @since  2010-04-03
	 */
	public class TipTool extends Sprite
	{
		
		//--------------------------------------
		//  Variables
		//--------------------------------------
		//tip sprite
		private var _tip:Sprite;
		
		/**
   		 *  constructor
    	 */
		public function TipTool()
		{
		}
		
		//--------------------------------------
		//  Function
		//--------------------------------------
		
		/**
		 *  add tiptools sprite to show
		 */
		public function addTipTool(obj:*,str:String,offsetX:Number = 0,offsetY:Number = 0):void
		{
			if(_tip) this.removeChild(_tip);
			_tip = new Sprite();
			_tip.mouseChildren = false;

			var col:uint = 0xff0000;
			var te:TextField = new TextField();
			te.autoSize = TextFieldAutoSize.LEFT;
			te.text = "   " + str + "   ";
			te.setTextFormat(new TextFormat("Arial",10,0xffffff));
	
			_tip.graphics.beginGradientFill(GradientType.LINEAR,[0x2b2b2b,0x2b2b2b],[1,1],[1,1]);
			_tip.graphics.lineStyle(1,0x000000,1,true);

			_tip.graphics.moveTo(0,0);
			_tip.graphics.lineTo(te.width,0);
			_tip.graphics.lineTo(te.width,te.height);
			_tip.graphics.lineTo(te.width - (te.width/2-5),te.height);
			_tip.graphics.lineTo(te.width - te.width/2,te.height+6);
			_tip.graphics.lineTo(te.width - (te.width/2 + 5),te.height);
			_tip.graphics.lineTo(0,te.height);
			_tip.graphics.lineTo(0,0);
			_tip.graphics.endFill();
	
			_tip.addChild(te);
			var po:Point = obj.localToGlobal(new Point(0,0));
			_tip.x = po.x - _tip.width/2 + offsetX;
			_tip.y = po.y + offsetY;
			this.stage.addChild(_tip);
		}
		
		/**
		 *  delete tiptools sprite
		 */
		public function delTipTool():void
		{
			if(_tip) this.stage.removeChild(_tip);
			_tip = null;
		}
	
	}
	
}