﻿package 
{
	import fl.transitions.Tween;
	import fl.transitions.easing.Strong;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.events.Event;

	public class Graph extends Sprite
	{

		private var graphContainer:Sprite = new Sprite();
		private var xmlFile:XML;
		private var urlLoader:URLLoader = new URLLoader();
		private var totalBars:int;

		private var tween:Tween;
		private var tf:TextFormat = new TextFormat();

		public function Graph():void
		{
			/* Text Format */

			tf.color = 0x666666;
			tf.size = 12;
			tf.font = "Helvetica";

			createGraphContainer();
			loadXML();
			createBars();
		}

		private function createGraphContainer():void
		{
			graphContainer.graphics.lineStyle(1, 0x9C9C9E);
			graphContainer.graphics.moveTo(30, 30);
			graphContainer.graphics.lineTo(30, 270);
			graphContainer.graphics.lineTo(570, 270);

			addChild(graphContainer);
		}

		private function loadXML(file:String = "graph.xml"):void
		{
			urlLoader.load(new URLRequest(file));
			urlLoader.addEventListener(Event.COMPLETE, parseXML);
		}

		private function parseXML(e:Event):void
		{
			xmlFile = new XML(e.target.data);
			totalBars = xmlFile.children().length();

			createBars();
			displayNames();
		}

		private function createBars():void
		{
			for (var i:int = 0; i < totalBars; i++)
			{
				var bar:Sprite = new Sprite();

				bar.graphics.beginFill(xmlFile.children()[i].@color);
				bar.graphics.drawRect(0, 0, xmlFile.@width, xmlFile.children()[i].@value);
				bar.graphics.endFill();

				bar.x = 40 + (xmlFile.@width * i) + (10*i);
				bar.y = 270 - bar.height;

				var val:TextField = new TextField();

				val.defaultTextFormat = tf;
				val.autoSize = TextFieldAutoSize.RIGHT;
				val.text = xmlFile.children()[i]. @ value;

				val.x = 55 + (xmlFile.@width * i) + (10*i);
				val.y = 255 - bar.height;

				tween = new Tween(bar,"height",Strong.easeOut,0,bar.height,1,true);
				
				addChild(bar);
				addChild(val);
			}
		}

		private function displayNames():void
		{
			for (var i:int = 0; i < totalBars; i++)
			{
				var color:Sprite = new Sprite();
				var names:TextField = new TextField();

				names.defaultTextFormat = tf;
				names.autoSize = TextFieldAutoSize.LEFT;
				names.text = xmlFile.children()[i]. @ name;

				names.x = 500;
				names.y = 30 + (20 * i);

				color.graphics.beginFill(xmlFile.children()[i].@color);
				color.graphics.drawRect(0, 0, 10, 10);
				color.graphics.endFill();

				color.x = 490;
				color.y = 31 + (20 * i);

				addChild(names);
				addChild(color);
			}
		}
	}
}